// KwadratDemo — demonstuje użycie
// funkcji przetwarzającej argumenty
#include <cstdio>
#include <cstdlib>
#include <iostream>
using namespace std;
// kwadrat — zwraca kwadrat przyjętego argumentu
//           dWartosc — wartość podniesiona do kwadratu
//           zwraca — kwadrat wartości zmiennej dWartosc
double square(double dWartosc)
{
    return dWartosc * dWartosc;
}
// wyswietlWyjasnienie — poinformuj użytkownika
// o regułach programu
void wyswietlWyjasnienie(void)
{
    cout << "Ten program sumuje kwadraty liczb z wielu ciągów.\n"
        << "Zakończ każdą sekwencję, wprowadzając \n"
        << " liczbę ujemną. Zakończ ciąg, \n"
        << "wprowadzając pustą sekwencję\n"
        << endl;
    return;
}
// sumujSekwencje — dodawaj kwadraty wartości
// podanych przez użytkownika, aż użytkownik wprowadzi
// liczbę ujemną
double sumujSekwencje(void)
{
    // pętla „nieskończona”
    double akumulator = 0.0;
    for(;;)
    {
        // pobierz następną liczbę
        double dWartosc = 0;
        cout << "Wprowadź następną liczbę: ";
        cin >> dWartosc;
        // jeśli jest ujemna…
        if (dWartosc < 0)
        {
            // …wyjdź z pętli
            break;
        }
        // …w przeciwnym razie oblicz kwadrat
        double wartosc = square(dWartosc);
        // i dodaj wartość zmiennej wartosc do zmiennej
        // akumulator
        akumulator += wartosc;
    }
    // zwróć zsumowaną wartość
    return akumulator;
}
int main(int nLiczbaArgumentow, char* pszArgs[])
{
    wyswietlWyjasnienie();
    // kontynuuj zliczanie sumy kwadratów
    for(;;)
    {
        // sumuj sekwencje liczb wprowadzonych z
        // klawiatury
        cout << "Rozpocznij następną sekwencję" << endl;
        double sumaWartosci = sumujSekwencje();
        // zakończ jeśli wartość zmiennej sumaWartosci jest mniejsza lub równa 0
        if (sumaWartosci <= 0.0)
        {
            break;
        }
        // zwróć wynik
        cout << "\nSuma kwadratów podanych wartości wynosi "
             << sumaWartosci << endl << endl;
    }
    // aby pozwolić użytkownikowi zobaczyć wynik programu
    // przed zakończeniem programu, poczekaj, aż użytkownik będzie gotowy
    cout << "Naciśnij Enter, aby kontynuować..." << endl;
    cin.ignore(10, '\n');
    cin.get();
    return 0;
}
