/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <memory>
using namespace std;

/* zdefiniuj operator wyjscia dla auto_ptr
 * - wyswietl wartosc obiektu lub wartosc NULL
 */
template <class T>
ostream& operator<< (ostream& strm, const auto_ptr<T>& p)
{
    // czy p posiada obiekt?
    if (p.get() == NULL) {
        strm << "NULL";         // NIE: wypisz NULL
    }
    else {
        strm << *p;             // TAK: wypisz obiekt
    }
    return strm;
}

int main()
{
    auto_ptr<int> p(new int(42));
    auto_ptr<int> q;

    cout << "po inicjalizacji:" << endl;
    cout << " p: " << p << endl;
    cout << " q: " << q << endl;

    q = p;
    cout << "przed przypisaniem wskaznikow:" << endl;
    cout << " p: " << p << endl;
    cout << " q: " << q << endl;

    *q += 13;                   // zmien wartosc  posiadana przez obiekt q 
    p = q;
    cout << "po zmianie i ponownym przypisaniu:" << endl;
    cout << " p: " << p << endl;
    cout << " q: " << q << endl;
}
