/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <memory>
using namespace std;

/* definiuj operator wyjsciowy dla klasy auto_ptr
 * - wyswietla wartosc obiektu lub BRAK
 */
template <class T>
ostream& operator<< (ostream& strm, const auto_ptr<T>& p)
{
    // czy wskaznik p jest wlascicielem jakiegos obiektu?
    if (p.get() == NULL) {
        strm << "BRAK";         // NIE: wyswietl BRAK
    }
    else {
        strm << *p;             // TAK: wyswietl wartosc obiektu
    }
    return strm;
}

int main()
{
    auto_ptr<int> p(new int(42));
    auto_ptr<int> q;

    cout << "po inicjalizacji:" << endl;
    cout << " p: " << p << endl;
    cout << " q: " << q << endl;

    q = p;
    cout << "po przypisaniu wskaznikow auto_ptr:" << endl;
    cout << " p: " << p << endl;
    cout << " q: " << q << endl;

    *q += 13;                   // zmien wartosc obiektu bedacego wlasnoscia wskaznika p
    p = q;
    cout << "po modyfikacji i ponownym przypisaniu:" << endl;
    cout << " p: " << p << endl;
    cout << " q: " << q << endl;
}

