/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <string>
using namespace std;

int main (int argc, char* argv[])
{
    string filename, basename, extname, tmpname;
    const string suffix("tmp");

    /* dla kazdego argumentu pobranego z wiersza polecen
     * (ktory jest zwyklym lancuchem znakowym w postaci uzywanej w jezyku C)
     */
    for (int i=1; i<argc; ++i) {
        // przetworz argument jako nazwe pliku
        filename = argv[i];
        
        // poszukaj w nazwie znaku kropki
        string::size_type idx = filename.find('.');
        if (idx == string::npos) {
            // nazwa pliku nie zawiera znaku kropki
            tmpname = filename + '.' + suffix;
        }
        else {
            /* podziel nazwe pliku na czesc podstawowa oraz rozszerzenie
             * - czesc podstawowa nazwy zawiera wszystkie znaki do znaku kropki
             * - rozszerzenie zawiera wszystkie znaki po znaku kropki
             */
            basename = filename.substr(0, idx);
            extname = filename.substr(idx+1);
            if (extname.empty()) {
                // zawiera kropke lecz prak rozszerzenia: dolacz tmp
                tmpname = filename;
                tmpname += suffix;
            }
            else if (extname == suffix) {
                // zastap rozszerzenie tmp za pomoca xxx
                tmpname = filename;
                tmpname.replace (idx+1, extname.size(), "xxx");
            }
            else {
                // zastap dowolne rozszerzenie tmp
                tmpname = filename;
                tmpname.replace (idx+1, string::npos, suffix);
            }
        }

        // wyswietl nazwe pliku oraz nazwe pliku tymczasowego
        cout << filename << " => " << tmpname << endl;
    }
}
