/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <map>
#include <string>
using namespace std;

int main()
{
    /* typ kontenera:
     * - mapa: elementy o postaci par klucz-wartosc
     * - string: klucze posiadaja typ string
     * - float: wartosci posiadaja typ float
     */
    typedef map<string,float> StringFloatMap;

    StringFloatMap coll;

    // wstaw do kolekcji kilka elementow
    coll["VAT"] = 0.22;
    coll["Pi"] = 3.1415;
    coll["dowolna liczba"] = 4983.223;
    coll["Zero"] = 0;

    /* wypisz wszystkie elementy
     * - iteruj po wszystkich elementach
     * - pierwsza skladowa elementu to klucz
     * - druga skladowa elementu to wartosc
     */
    StringFloatMap::iterator pos;
    for (pos = coll.begin(); pos != coll.end(); ++pos) {
        cout << "klucz: \"" << pos->first << "\" "
             << "wartosc: " << pos->second << endl;
    }
}
