/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

int main()
{
    vector<int> coll;
    vector<int>::iterator pos;

    // wstaw elementy od 1 do 6 w przypadkowej kolejnosci
    coll.push_back(2);
    coll.push_back(5);
    coll.push_back(4);
    coll.push_back(1);
    coll.push_back(6);
    coll.push_back(3);

    // znajdz i wypisz element o najmniejszej i najwiekszej wartosci
    pos = min_element (coll.begin(), coll.end());
    cout << "min: " << *pos << endl;
    pos = max_element (coll.begin(), coll.end());
    cout << "max: " << *pos << endl;

    // posortuj wszystkie elementy
    sort (coll.begin(), coll.end());

    // znajdz pierwszy element o wartosci 3
    pos = find (coll.begin(), coll.end(),  // zakres
                3);                        // wartosc

    // odwroc kolejnosc elementow poczawszy od znalezionego elementu o wartosci 3 az do konca
    reverse (pos, coll.end());

    // wypisz wszystkie elementy
    for (pos=coll.begin(); pos!=coll.end(); ++pos) {
        cout << *pos << ' ';
    }
    cout << endl;
}
