/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <list>
#include <algorithm>
#include "print.hpp"
using namespace std;

// obiekt funkcyjny dodajacy wartosc, ktora zostal zainicjalizowany
class AddValue {
  private:
    int theValue;    // wartosc do dodania
  public:
    // konstruktor inicjalizuje wartosc do dodania
    AddValue(int v) : theValue(v) {
    }

    // 'wywolanie funkcji wobec elementu dodaje wartosc
    void operator() (int& elem) const {
        elem += theValue;
    }
};

int main()
{
    list<int> coll;

    // wstaw elementy od 1 do 9
    for (int i=1; i<=9; ++i) {
        coll.push_back(i);
    }

    PRINT_ELEMENTS(coll,"wartosci poczatkowe:            ");

    // do kazdego elementu dodaj wartosc 10
    for_each (coll.begin(), coll.end(),    // zakres
              AddValue(10));               // operacja

    PRINT_ELEMENTS(coll,"po dodaniu liczby 10:           ");

    // do kazdego elementu dodaj wartosc pierwszego elementu
    for_each (coll.begin(), coll.end(),    // zakres
              AddValue(*coll.begin()));    // operacja

    PRINT_ELEMENTS(coll,"po dodaniu pierwszego elementu: ");
}
