/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <valarray>
using namespace std;

// wyswietl zawartosc tablicy valarray
template <class T>
void printValarray (const valarray<T>& va)
{
    for (int i=0; i<va.size(); i++) {
        cout << va[i] << ' ';
    }
    cout << endl;
}

int main()
{
    // zdefiniuj dwie tablice typu valarray zawierajace po dziesiec elementow
    valarray<double> va1(10), va2(10);

    // do pierwszej tablicy przypisz wartosci 0.0, 1.1, az do 9.9 
    for (int i=0; i<10; i++) {
        va1[i] = i * 1.1;
    }

    // do wszystkich elementow drugiej tablicy przypisz wartosc  -1 
    va2 = -1;

    // wyswietl zawartosc kazdej z tablic
    printValarray(va1);
    printValarray(va2);

    // wyswietl wartosc minimalna, maksymalna oraz sume z pierwszej tablicy
    cout << "min(): " << va1.min() << endl;
    cout << "max(): " << va1.max() << endl;
    cout << "sum(): " << va1.sum() << endl;

    // przypisz wartosci pierwszej do drugiej tablicy
    va2 = va1;

    // usun wszystkie elementy z pierwszej tablicy
    va1.resize(0);

    // ponownie wyswietl zawartosc obu tablic
    printValarray(va1);
    printValarray(va2);
}
