/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include "inbuf1.hpp"

int main()
{
    inbuf ib;                // utworz specjalny bufor strumienia
    std::istream in(&ib);    // zainicjalizuj przy uzyciu tego bufora strumien wejsciowy

    char c;
    for (int i=1; i<=20; i++) {
        // odczytaj kolejny znak (koniec bufora)
        in.get(c);

        // wypisz ten znak (i oproznij bufor)
        std::cout << c << std::flush;

        // po osmiu znakach umiesc dwa znaki w strumieniu
        if (i == 8) {
            in.unget();
            in.unget();
        }
    }
    std::cout << std::endl;
}
