/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <iterator>
using namespace std;

int main()
{
    // iterator bufora strumienia wejsciowego dla cin
    istreambuf_iterator<char> inpos(cin);

    // iterator wskazujacy na koniec strumienia
    istreambuf_iterator<char> endpos;

    // iterator bufora strumienia wyjsciowego dla cout
    ostreambuf_iterator<char> outpos(cout);

    // dopoki iterator jest poprawny
    while (inpos != endpos) {
        *outpos = *inpos;    // przypisz jego wartosc do iteratora wyjsciowego
        ++inpos;
        ++outpos;
    }
}
