/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <string>
#include <deque>
#include <set>
#include <algorithm>
using namespace std;


/* klasa Person
 */
class Person {
  private:
    string fn;    // imie
    string ln;    // nazwisko
  public:
    Person() {
    }
    Person(const string& f, const string& n)
     : fn(f), ln(n) {
    }
    string firstname() const;
    string lastname() const;
    // ...
};

inline string Person::firstname() const {
    return fn;
}

inline string Person::lastname() const {
    return ln;
}

ostream& operator<< (ostream& s, const Person& p)
{
    s << "[" << p.firstname() << " " << p.lastname() << "]";
    return s;
}


/* klasa predykatu funkcji
 * - operator () zwraca, czy dana osoba jest 'mniejsza' od drugiej osoby
 */
class PersonSortCriterion {
  public:
    bool operator() (const Person& p1, const Person& p2) const {
         /* osoba jest 'mniejsza' od drugiej osoby
         * - jesli nazwisko jest 'mniejsze'
         * - jesli nazwisko jest 'rowne' oraz imie jest 'mniejsze'
         */
         return p1.lastname()<p2.lastname() ||
               (!(p2.lastname()<p1.lastname()) &&
                p1.firstname()<p2.firstname());
    }
};


int main()
{
    Person p1("jan","kowalski");
    Person p2("anna","kowalska");
    Person p3("jacek","kowalski");
    Person p4("piotr","nowak");
    Person p5("pawel","zalewski");
    Person p6("jacek","baran");
    Person p7("jacek","marzec");

    // zadeklaruj typ zbioru o specjalnym kryterium sortowania
    typedef set<Person,PersonSortCriterion> PersonSet;

    // utworz taka kolekcje
    PersonSet coll;
    coll.insert(p1);
    coll.insert(p2);
    coll.insert(p3);
    coll.insert(p4);
    coll.insert(p5);
    coll.insert(p6);
    coll.insert(p7);

    // wykonaj na elementach jakas operacje
    // - w tym przypadku: wypisz je
    cout << "zbior:" << endl;
    PersonSet::iterator pos;
    for (pos = coll.begin(); pos != coll.end(); ++pos) {
        cout << *pos << endl;
    }
}

