/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <list>
#include <algorithm>
#include "print.hpp"
using namespace std;

class IntSequence {
  private:
    int value;
  public:
    // konstruktor
    IntSequence (int initialValue)
     : value(initialValue) {
    }

    // "wywolanie funkcji"
    int operator() () {
        return value++;
    }
};

int main()
{
    list<int> coll;

    // wstaw wartosci od 1 do 9
    generate_n (back_inserter(coll),    // poczatek
                9,                      // liczba elementow
                IntSequence(1));        // generuje wartosci

    PRINT_ELEMENTS(coll);

    // zastap elementy od drugiego do przedostatniego wartosciami poczawszy od 42
    generate (++coll.begin(),           // poczatek
              --coll.end(),             // koniec
              IntSequence(42));         // generuje wartosci

    PRINT_ELEMENTS(coll);
}
