/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

// obiekt funkcyjny do obliczania wartosci sredniej
class MeanValue {
  private:
    long num;    // liczba elementow
    long sum;    // suma wartosci wszystkich elementow
  public:
    // konstruktor
    MeanValue () : num(0), sum(0) {
    }

    // "wywolanie funkcji"
    // - przetworz jeszcze jeden element ciagu
    void operator() (int elem) {
        num++;          // inkrementuj licznik
        sum += elem;    // dodaj wartosc
    }

    // zwroc wartosc srednia
    double value () {
        return static_cast<double>(sum) / static_cast<double>(num);
    }
};

int main()
{
    vector<int> coll;

    // wstaw elementy od 1 do 8
    for (int i=1; i<=8; ++i) {
        coll.push_back(i);
    }

    // oblicz i wypisz wartosc srednia
    MeanValue mv = for_each (coll.begin(), coll.end(),  // zakres
                             MeanValue());              // operacja
    cout << "wartosc srednia: " << mv.value() << endl;
}
