/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <vector>
#include <string>
#include <algorithm>
#include <iterator>
using namespace std;

int main()
{
    // utworz pusty wektor na lancuchy
    vector<string> sentence;

    // zarezerwuj pamiec na 5 elementow, aby uniknac realokacji
    sentence.reserve(5);

    // dolacz kilka elementow
    sentence.push_back("Witaj,");
    sentence.push_back("jak");
    sentence.push_back("sie");
    sentence.push_back("masz");
    sentence.push_back("?");

    // wypisz elementy rozdzielone spacjami
    copy (sentence.begin(), sentence.end(),
          ostream_iterator<string>(cout," "));
    cout << endl;

    // wypisz 'dane techniczne'
    cout << "  max_size(): " << sentence.max_size() << endl;
    cout << "  size():     " << sentence.size()     << endl;
    cout << "  capacity(): " << sentence.capacity() << endl;

    // zamien drugi element z czwartym
    swap (sentence[1], sentence[3]);

    // przed elementem "?" wstaw element "zawsze"
    sentence.insert (find(sentence.begin(),sentence.end(),"?"),
                     "zawsze");

    // przypisz "!" do ostatniego elementu
    sentence.back() = "!";
    
    // wypisz elementy rozdzielone spacjami
    copy (sentence.begin(), sentence.end(),
          ostream_iterator<string>(cout," "));
    cout << endl;

    // ponownie wypisz 'dane techniczne'
    cout << "  max_size(): " << sentence.max_size() << endl;
    cout << "  size():     " << sentence.size()     << endl;
    cout << "  capacity(): " << sentence.capacity() << endl;
}
