/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <map>
#include <string>
#include <iomanip>
using namespace std;

int main()
{
    // zdefiniuj typ multimap jako slownik typu string-string
    typedef multimap<string,string> StrStrMMap;

    // utworz pusty slownik
    StrStrMMap dict;

    // wstaw kilka elementow w przypadkowej kolejnosci
    dict.insert(make_pair("day","dzien"));
    dict.insert(make_pair("strange","obcy"));
    dict.insert(make_pair("car","samochod"));
    dict.insert(make_pair("smart","elegancki"));
    dict.insert(make_pair("trait","cecha"));
    dict.insert(make_pair("strange","dziwny"));
    dict.insert(make_pair("smart","sprytny"));
    dict.insert(make_pair("smart","madry"));
    dict.insert(make_pair("clever","sprytny"));

    // wypisz wszystkie elementy
    StrStrMMap::iterator pos;
    cout.setf (ios::left, ios::adjustfield);
    cout << ' ' << setw(10) << "angielski "
         << "polski " << endl;
    cout << setfill('-') << setw(20) << ""
         << setfill(' ') << endl;
    for (pos = dict.begin(); pos != dict.end(); ++pos) {
        cout << ' ' << setw(10) << pos->first.c_str()
             << pos->second << endl;
    }
    cout << endl;

    // wypisz wszystkie wartosci dla klucza "smart"
    string word("smart");
    cout << word << ": " << endl;
    for (pos = dict.lower_bound(word);
         pos != dict.upper_bound(word); ++pos) {
            cout << "    " << pos->second << endl;
    }

    // wypisz wszystkie klucze dla wartosci "sprytny"
    word = ("sprytny");
    cout << word << ": " << endl;
    for (pos = dict.begin(); pos != dict.end(); ++pos) {
        if (pos->second == word) {
            cout << "    " << pos->first << endl;
        }
    }
}
