/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <bitset>
#include <iostream>
#include <string>
#include <limits>
using namespace std;

int main()
{
    /* wypisz kilka liczb w zapisie dwojkowym
     */
    cout << "267 jako dwojkowy typ short: "
         << bitset<numeric_limits<unsigned short>::digits>(267)
         << endl;

    cout << "267 jako dwojkowy typ long:  "
         << bitset<numeric_limits<unsigned long>::digits>(267)
         << endl;

    cout << "10,000,000 na 24 bitach:     "
         << bitset<24>(1e7) << endl;

    /* przeksztalc reprezentacje dwojkowa na liczbe calkowita
     */
    cout << "\"1000101011\" jako liczba:    "
         << bitset<100>(string("1000101011")).to_ulong() << endl;
}
