/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
/* ************************************************************
 *  Stack.hpp
 *   - bezpieczniejsza i wygodniejsza klasa stosu
 * ************************************************************/
#ifndef STACK_HPP
#define STACK_HPP

#include <deque>
#include <exception>

template <class T>
class Stack {
  protected:
    std::deque<T> c;        // kontener na elementy

  public:
    /* klasa wyjatkow dla przypadku wywolania funkcji pop() oraz top() dla pustego stosu
     */
    class ReadEmptyStack : public std::exception {
      public:
        virtual const char* what() const throw() {
            return "odczyt pustego stosu";
        }
    };
  
    // liczba elementow
    typename std::deque<T>::size_type size() const {
        return c.size();
    }

    // czy stos jest pustY?
    bool empty() const {
        return c.empty();
    }

    // poloz element na stos
    void push (const T& elem) {
        c.push_back(elem);
    }

    // zdejmij jeden element ze stosu i zwroc jego wartosc
    T pop () {
        if (c.empty()) {
            throw ReadEmptyStack();
        }
        T elem(c.back());
        c.pop_back();
        return elem;
    }

    // zwroc wartosc nastepnego elementu
    T& top () {
        if (c.empty()) {
            throw ReadEmptyStack();
        }
        return c.back();
    }
};

#endif /* STACK_HPP */
