/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    deque<int> coll;
    list<int> subcoll;

    INSERT_ELEMENTS(coll,1,7);
    INSERT_ELEMENTS(coll,1,7);

    INSERT_ELEMENTS(subcoll,3,6);

    PRINT_ELEMENTS(coll,   "coll:    ");
    PRINT_ELEMENTS(subcoll,"subcoll: ");

    // szukaj pierwszego wystapienia ciagu subcoll w kolekcji coll
    deque<int>::iterator pos;
    pos = search (coll.begin(), coll.end(),         // zakres
                  subcoll.begin(), subcoll.end());  // podzakres

    // wykonuj petle tak dlugo, jak dlugo ciag subcoll znajdowany jest jako podzakres kolekcji coll
    while (pos != coll.end()) { 
        // wypisz pozycje pierwszego elementu
        cout << "znaleziono ciag subcoll wystepujacy na pozycjach poczawszy od elementu "
             << distance(coll.begin(),pos) + 1
             << endl;

        // szukaj nastepnego wystapienia ciagu subcoll
        ++pos;
        pos = search (pos, coll.end(),                  // zakres
                      subcoll.begin(), subcoll.end());  // podzakres
    }
}
