/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    list<int> coll1;

    INSERT_ELEMENTS(coll1,1,6);
    INSERT_ELEMENTS(coll1,1,9);
    PRINT_ELEMENTS(coll1);

    // wypisz wszystkie elementy oprocz tych o wartosci 3
    remove_copy(coll1.begin(), coll1.end(),       // zrodlo
                ostream_iterator<int>(cout," "),  // przeznaczenie
                3);                               // usuwana wartosc
    cout << endl;

    // wypisz wszystkie elementy oprocz tych o wartosciach wiekszych od 4
    remove_copy_if(coll1.begin(), coll1.end(),      // zrodlo
                   ostream_iterator<int>(cout," "), // przeznaczenie
                   bind2nd(greater<int>(),4));      // usuwane elementy
    cout << endl;

    // kopiuj wszystkie elementy wieksze od 3 do wielozbioru
    multiset<int> coll2;
    remove_copy_if(coll1.begin(), coll1.end(),    // zrodlo
                   inserter(coll2,coll2.end()),   // przeznaczenie
                   bind2nd(less<int>(),4));       // niekopiowane elementy
    PRINT_ELEMENTS(coll2);
}
