/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    vector<int> coll;
    vector<int>::iterator pos;

    INSERT_ELEMENTS(coll,1,9);

    PRINT_ELEMENTS(coll,"coll: ");

    // znajdz pierwszy element wiekszy od 3
    pos = find_if (coll.begin(), coll.end(),    // zakres
                   bind2nd(greater<int>(),3));  // kryterium

    // wypisz jego pozycje
    cout << "pierwszym elementem wiekszym od 3 jest "
         << distance(coll.begin(),pos) + 1
         << ". element" << endl;

    // znajdz pierwszy element podzielny przez 3
    pos = find_if (coll.begin(), coll.end(),
                   not1(bind2nd(modulus<int>(),3)));

    // wypisz jego pozycje
    cout << "pierwszym elementem podzielnym przez 3 jest "
         << distance(coll.begin(),pos) + 1
         << ". element" << endl;
}
