/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

bool isEven (int elem)
{
    return elem % 2 == 0;
}

int main()
{
    vector<int> coll;
    int num;

    INSERT_ELEMENTS(coll,1,9);
    PRINT_ELEMENTS(coll,"kontener coll: ");

    // zlicz i wypisz elementy o wartosci 4
    num = count (coll.begin(), coll.end(),       // zakres
                 4);                             // wartosc
    cout << "liczba elementow rownych wartosci 4:           " << num << endl;

    // zlicz elementy o wartosciach parzystych
    num = count_if (coll.begin(), coll.end(),    // zakres
                    isEven);                     // kryterium
    cout << "liczba elementow o wartosciach parzystych:     " << num << endl;

    // zlicz elementy o wartosciach wiekszych od 4
    num = count_if (coll.begin(), coll.end(),    // zakres
                    bind2nd(greater<int>(),4));  // kryterium
    cout << "liczba elementow o wartosciach wiekszych od 4: " << num << endl;
}
