#include <iostream>

enum BOOL {FALSE, TRUE};

class Mammal
{
public:
    Mammal():age(1) {  }
    virtual ~Mammal() { }
    virtual void speak() const = 0;
    virtual void move() const = 0;
protected:
    int age;
};

class Dog : public Mammal
{
public:
    void speak() const { std::cout << "Hau!\n"; }
    void move() const { std::cout << "Chodzenie przy nodze...\n"; }
};

class Cat : public Mammal
{
public:
    void speak() const { std::cout << "Miau!\n"; }
    void move() const { std::cout << "Chodzenie ukradkiem...\n"; }
};

class Horse : public Mammal
{
public:
    void speak() const { std::cout << "Rżenie!\n"; }
    void move() const { std::cout << "Galop...\n"; }
};

int main()
{
    void (Mammal::*pFunc)() const = 0;
    Mammal* ptr = 0;
    int animal;
    int method;
    bool fQuit = false;

    while (fQuit == false)
    {
        std::cout << "(0) Wyjście (1) Pies (2) Kot (3) Koń: ";
        std::cin >> animal;
        switch (animal)
        {
        case 1:
            ptr = new Dog;
            break;
        case 2:
            ptr = new Cat;
            break;
        case 3:
            ptr = new Horse;
            break;
        default:
            fQuit = true;
            break;
        }
        if (fQuit)
            break;

        std::cout << "(1) Głos (2) Ruch: ";
        std::cin >> method;
        switch (method)
        {
        case 1:
            pFunc = &Mammal::speak;
            break;
        default:
            pFunc = &Mammal::move;
            break;
        }

        (ptr->*pFunc)();
        delete ptr;
    }
    return 0;
}
