#include <iostream>

enum COLOR { Red, Green, Blue, Yellow, White, Black, Brown } ;

class Animal // Wspólna klasa bazowa dla klas Horse i Fish.
{
public:
    Animal(int);
    virtual ~Animal() { std::cout << "Destruktor klasy Animal...\n"; }
    virtual int getAge() const { return age; }
    virtual void setAge(int newAge) { age = newAge; }
    virtual void sleep() const = 0;
    virtual void eat() const = 0;
    virtual void reproduce() const = 0;
    virtual void move() const = 0;
    virtual void speak() const = 0;
private:
    int age;
};

Animal::Animal(int newAge):
age(newAge)
{
    std::cout << "Konstruktor klasy Animal...\n";
}

class Mammal : public Animal
{
public:
    Mammal(int newAge):Animal(newAge)
        { std::cout << "Konstruktor klasy Mammal...\n";}
    virtual ~Mammal() { std::cout << "Destruktor klasy Mammal...\n";}
    virtual void reproduce() const
        { std::cout << "Rozmnażanie dla klasy Mammal...\n"; }
};

class Fish : public Animal
{
public:
    Fish(int newAge):Animal(newAge)
        { std::cout << "Konstruktor klasy Fish...\n";}
    virtual ~Fish()
        { std::cout << "Destruktor klasy Fish...\n";  }
    virtual void sleep() const
        { std::cout << "Ryba śpi...\n"; }
    virtual void eat() const
        { std::cout << "Ryba żeruje...\n"; }
    virtual void reproduce() const
        { std::cout << "Ryba składa jaja...\n"; }
    virtual void move() const
        { std::cout << "Ryba pływa...\n";   }
    virtual void speak() const { }
};

class Horse : public Mammal
{
public:
    Horse(int newAge, COLOR newColor):
        Mammal(newAge), color(newColor)
        { std::cout << "Konstruktor klasy Horse...\n"; }
    virtual ~Horse()
        { std::cout << "Destruktor klasy Horse...\n"; }
    virtual void speak() const
        { std::cout << "Ihaaa!\n"; }
    virtual COLOR getcolor() const
        { return color; }
    virtual void sleep() const
        { std::cout << "Koń śpi...\n"; }
    virtual void eat() const
        { std::cout << "Koń się pasie...\n"; }
    virtual void move() const
        { std::cout << "Koń biegnie...\n";}

protected:
    COLOR color;
};

class Dog : public Mammal
{
public:
    Dog(int newAge, COLOR newColor ):
        Mammal(newAge), color(newColor)
        { std::cout << "Konstruktor klasy Dog...\n"; }
    virtual ~Dog()
        { std::cout << "Destruktor klasy Dog...\n"; }
    virtual void speak() const
        { std::cout << "Hau, hau!\n"; }
    virtual void sleep() const
        { std::cout << "Pies chrapie...\n"; }
    virtual void eat() const
        { std::cout << "Pies je eating...\n"; }
    virtual void move() const
        { std::cout << "Pies biegnie...\n"; }
    virtual void reproduce() const
        { std::cout << "Pies się rozmnaża...\n"; }

protected:
    COLOR color;
};

int main()
{
    Animal *pAnimal = 0;
    int choice;
    bool fQuit = false;

    while (1)
    {
        std::cout << "(1) Pies (2) Koń (3) Ryba (0) Wyjście: ";
        std::cin >> choice;

        switch (choice)
        {
        case 1:
            pAnimal = new Dog(5, Brown);
            break;
        case 2:
            pAnimal = new Horse(4, Black);
            break;
        case 3:
            pAnimal = new Fish(5);
            break;
        default:
            fQuit = true;
            break;
        }
        if (fQuit)
            break;

        pAnimal->speak();
        pAnimal->eat();
        pAnimal->reproduce();
        pAnimal->move();
        pAnimal->sleep();
        delete pAnimal;
        std::cout << "\n";
    }
    return 0;
}
