#include <iostream>

class Mammal
{
public:
    Mammal():age(1) { std::cout << "Konstruktor klasy Mammal...\n"; }
    virtual ~Mammal() { std::cout << "Destruktor klasy Mammal...\n"; }
    Mammal (const Mammal &rhs);
    virtual void speak() const { std::cout << "Ssak wydaje dźwięki!\n"; }
    virtual Mammal* clone() { return new Mammal(*this); }
    int getAge() const { return age; }

protected:
    int age;
};

Mammal::Mammal (const Mammal &rhs):age(rhs.getAge())
{
    std::cout << "Konstruktor kopiujący klasy Mammal...\n";
}

class Dog : public Mammal
{
public:
    Dog() { std::cout << "Konstruktor klasy Dog...\n"; }
    virtual ~Dog() { std::cout << "Destruktor klasy Dog...\n"; }
    Dog (const Dog &rhs);
    void speak() const { std::cout << "Hau!\n"; }
    virtual Mammal* clone() { return new Dog(*this); }
};

Dog::Dog(const Dog &rhs):
Mammal(rhs)
{
    std::cout << "Konstruktor kopiujący klasy Dog...\n";
}

class Cat : public Mammal
{
public:
    Cat() { std::cout << "Konstruktor klasy Cat...\n"; }
    virtual ~Cat() { std::cout << "Destruktor klasy Cat...\n"; }
    Cat (const Cat&);
    void speak() const { std::cout << "Miau!\n"; }
    virtual Mammal* Clone() { return new Cat(*this); }
};

Cat::Cat(const Cat &rhs):
Mammal(rhs)
{
    std::cout << "Konstruktor kopiujący klasy Cat...\n";
}

enum ANIMALS { MAMMAL, DOG, CAT};
const int numAnimalTypes = 3;
int main()
{
    Mammal *array[numAnimalTypes];
    Mammal *ptr;
    int choice, i;
    for (i = 0; i < numAnimalTypes; i++)
    {
        std::cout << "(1) pies (2) kot (3) ssak: ";
        std::cin >> choice;
        switch (choice)
        {
        case DOG:
            ptr = new Dog;
            break;
        case CAT:
            ptr = new Cat;
            break;
        default:
            ptr = new Mammal;
            break;
        }
        array[i] = ptr;
    }
    Mammal *otherArray[numAnimalTypes];
    for (i=0; i < numAnimalTypes; i++)
    {
        array[i]->speak();
        otherArray[i] = array[i]->clone();
    }
    for (i=0; i < numAnimalTypes; i++)
    {
        otherArray[i]->speak();
    }
    return 0;
}
