#include <iostream>

class SimpleCat
{
public:
    SimpleCat();               // Konstruktor.
    SimpleCat(SimpleCat&);     // Konstruktor kopiujący.
    ~SimpleCat();              // Destruktor.
};

SimpleCat::SimpleCat()
{
    std::cout << "Konstruktor klasy SimpleCat...\n";
}

SimpleCat::SimpleCat(SimpleCat&)
{
    std::cout << "Konstruktor kopiujący klasy SimpleCat...\n";
}

SimpleCat::~SimpleCat()
{
    std::cout << "Destruktor klasy SimpleCat...\n";
}

SimpleCat FunctionOne(SimpleCat theCat);
SimpleCat* FunctionTwo(SimpleCat *theCat);

int main()
{
    std::cout << "Utworzenie obiektu...\n";
    SimpleCat Frisky;
    std::cout << "Wywołanie FunctionOne...\n";
    FunctionOne(Frisky);
    std::cout << "Wywołanie FunctionTwo...\n";
    FunctionTwo(&Frisky);
    return 0;
}

// FunctionOne, przekazanie przez wartość.
SimpleCat FunctionOne(SimpleCat theCat)
{
    std::cout << "Zakończenie działania FunctionOne...\n";
    return theCat;
}

// FunctionTwo, przekazanie przez referencję.
SimpleCat* FunctionTwo (SimpleCat *theCat)
{
    std::cout << "Zakończenie działania FunctionTwo...\n";
    return theCat;
}
