#include <iostream>

class Condition
{
public:
    Condition() { }
    virtual ~Condition() {}
    virtual void log() = 0;
};

class Normal : public Condition
{
public:
    Normal() { log(); }
    virtual ~Normal() {}
    virtual void log()
        { std::cout << "Rejestracja normalnych warunków...\n"; }
};

class Error : public Condition
{
public:
    Error() { log(); }
    virtual ~Error() {}
    virtual void log() { std::cout << "Rejestracja błędu!\n"; }
};

class Alarm : public Condition
{
public:
    Alarm();
    virtual ~Alarm() {}
    virtual void warn() { std::cout << "Ostrzeżenie!\n"; }
    virtual void log() { std::cout << "Ogólny dziennik zdarzeń alarmu.\n"; }
    virtual void call() = 0;
};

Alarm::Alarm()
{
    log();
    warn();
}

class FireAlarm : public Alarm
{
public:
    FireAlarm() { log();};
    virtual ~FireAlarm() {}
    virtual void call() { std::cout<< "Powiadomienie straży pożarnej!\n"; }
    virtual void log() { std::cout << "Rejestracja danych o powiadomieniu straży pożarnej.\n"; }
};

int main()
{
    int input;
    int okay = 1;
    Condition *pCondition;
    while (okay)
    {
        std::cout << "(0) Wyjście (1) Normalnie (2) Pożar: ";
        std::cin >> input;
        okay = input;
        switch (input)
        {
        case 0:
            break;
        case 1:
            pCondition = new Normal;
            delete pCondition;
            break;
        case 2:
            pCondition = new FireAlarm;
            delete pCondition;
            break;
        default:
            pCondition = new Error;
            delete pCondition;
            okay = 0;
            break;
        }
    }
    return 0;
}
