#include <iostream>

enum BREED { YORKIE, CAIRN, DANDIE, SHETLAND, DOBERMAN, LAB };

class Mammal
{
public:
    // Konstruktory.
    Mammal();
    Mammal(int age);
    ~Mammal();

    // Akcesory.
    int getAge() const { return age; }
    void setAge(int newAge) { age = newAge; }
    int getWeight() const { return weight; }
    void setWeight(int newWeight) { weight = newWeight; }

    // Pozostałe metody składowe.
    void speak() const { std::cout << "Dźwięk ssaka!\n"; }
    void sleep() const { std::cout << "Ciiiicho. Właśnie śpię.\n"; }

protected:
    int age;
    int weight;
};

class Dog : public Mammal
{
public:
    // Konstruktory.
    Dog();
    Dog(int age);
    Dog(int age, int weight);
    Dog(int age, BREED breed);
    Dog(int age, int weight, BREED breed);
    ~Dog();

    // Akcesory.
    BREED getBreed() const { return breed; }
    void setBreed(BREED newBreed) { breed = newBreed; }

    // Pozostałe metody składowe.
    void wagTail() { std::cout << "Macham ogonem...\n"; }
    void begForFood() { std::cout << "Proszę o jedzenie...\n"; }

private:
    BREED breed;
};

Mammal::Mammal():
age(3),
weight(5)
{
    std::cout << "Konstruktor klasy Mammal...\n";
}

Mammal::Mammal(int age):
age(age),
weight(5)
{
    std::cout << "Mammal(int) constructor...\n";
}

Mammal::~Mammal()
{
    std::cout << "Destruktor klasy Mammal...\n";
}

Dog::Dog():
Mammal(),
breed(YORKIE)
{
    std::cout << "Konstruktor klasy Dog...\n";
}

Dog::Dog(int age):
Mammal(age),
breed(YORKIE)
{
    std::cout << "Konstruktor klasy Dog(int)...\n";
}

Dog::Dog(int age, int newWeight):
Mammal(age),
breed(YORKIE)
{
    weight = newWeight;
    std::cout << "Konstruktor klasy Dog(int, int)...\n";
}

Dog::Dog(int age, int newWeight, BREED breed):
Mammal(age),
breed(breed)
{
    weight = newWeight;
    std::cout << "Konstruktor klasy Dog(int, int, BREED)...\n";
}

Dog::Dog(int age, BREED newBreed):
Mammal(age),
breed(newBreed)
{
    std::cout << "Konstruktor klasy Dog(int, BREED)...\n";
}

Dog::~Dog()
{
    std::cout << "Destruktor klasy Dog...\n";
}

int main()
{
    Dog fido;
    Dog rover(5);
    Dog buster(6, 8);
    Dog yorkie (3, YORKIE);
    Dog dobbie (4, 20, DOBERMAN);
    fido.speak();
    rover.wagTail();
    std::cout << "Yorkie ma "
        << yorkie.getAge() << " lat.\n";
    std::cout << "Dobbie waży "
        << dobbie.getWeight() << " kg.\n";
    return 0;
}
