#include <iostream>
#include <cctype> /* std::toupper */

int main()
{
    std::string text { "haker" };
    /* Operatorem dodawania możliwe jest doklejenie
       tekstu do końca napisu. Poniższy kod jest
       równoważny:
       text = text + ".info"; */
    text += ".info"; //haker.info
    std::cout << text << std::endl;
  
    /* Możliwe jest też łączenie części napisów */
    std::string part1 { "Etyczny " };
    std::string part2 { "hacking" };
    text = part1 + part2;
    std::cout << text << std::endl; //Etyczny hacking
  
    /* Możliwe jest pobranie fragmentu napisu
       poprzez funkcję substr(), gdzie podajemy
       najpierw indeks, a potem długość fragmentu. */
    std::string slogan { "Spreading "
                         "knowledge "
                         "like a "
                         "virus." };
    //not-a-virus
    std::cout << "not-a-" + slogan.substr(27, 5)
              << std::endl;
  
    /* Możliwe jest też poprzez indeks odwołanie
       się do pojedynczego znaku. */
    std::string vx { slogan[27], 'x' }; //vx
    std::cout << vx << std::endl; //vx
  
    /* Zmiana pojedynczych znaków na duże litery */
    vx[0] = std::toupper(vx[0]);
    vx[1] = std::toupper(vx[1]);
    std::cout << vx << std::endl; //VX (duże litery)
  
    return EXIT_SUCCESS;
}
