/* Podstawową różnicą pomiędzy pętlami while oraz do-while jest miejsce sprawdzania warunku logicznego.
W instrukcji do-while warunek jest sprawdzany na końcu bloku kodu (lub pojedynczej instrukcji).
Dlatego kod w pętli wykona się jeden raz, pomimo, że warunek daje wartość false (nie jest spełniony).
Może to powodować łatwiejsze popełnianie błędów przez programistę.

Twórca języka C++ (pan Bjarne Stroustrup) w swojej książce
„The C++ Programming Language, 4th Edition”
nie zaleca stosowania pętli do-while.

Cytat:
„Consequently, I recommend avoiding do-statements.”

Bjarne Stroustrup,
The C++ Programming Language (4th Edition),
ISBN: 9780321563842, Rozdział 9.5.4 do Statements */

#include <iostream>

int main()
{
    setlocale(LC_ALL, "");
  
    while (2 + 2 == 5) /* Warunek niespełniony (false). */
    {
        std::cout << "To się nie wyświetli." << std::endl;
    }
  
    do
    {
        std::cout << "To się wyświetli." << std::endl;
    } while (2 + 2 == 5)  /* Warunek niespełniony (false). */
    
    return EXIT_SUCCESS;
}
