#include <iostream>

class item
{
private:
    std::string name;
public:
    item(std::string n) : name(n) { }
  
    item(item& i) : name(i.name) { }
  
    item(item&& i) noexcept : name(std::move(i.name)) { }
  
    std::string get_name() { return this->name; }
};

int main()
{
    ::setlocale(LC_ALL, "");
  
    item item_a("(jakieś dane)");
  
    item item_b = std::move(item_a);
  
    std::cout << "item_a = "
        << item_a.get_name()
        << std::endl;
  
    std::cout << "item_b = "
        << item_b.get_name()
        << std::endl;
  
    item item_c = item_b;
  
    std::cout << "item_c = "
        << item_c.get_name()
        << std::endl;
  
    return EXIT_SUCCESS;
}
