#include <iostream>
#include <memory>

int main()
{
    setlocale(LC_ALL, "");
  
    /* Stworzenie wskaźnika inteligentnego „shared_ptr” */
    std::shared_ptr<int> ptr = std::make_shared<int>(64);
  
    std::cout << "*ptr = " << *ptr << std::endl;
    std::cout << "ptr = " << ptr << std::endl;
  
    /* Wskaźniki obserwujące typu „weak_ptr” ... */
    std::weak_ptr<int> ptr_2 = ptr;
    std::weak_ptr<int> ptr_3 = ptr;
    std::weak_ptr<int> ptr_4 = ptr;
  
    /* ... nie zwiększają licznika odwołań */
    std::cout << "Licznik odwołań: " << ptr.use_count() << std::endl;
  
    /* Dostęp do obiektu bez zarządzania jego cyklem życia */
    std::cout << "*ptr_2.lock() = " << *ptr_2.lock() << std::endl;
  
    /* Wskaźnik można usunąć przez reset(); lub zostawić do
       automatycznego usunięcia. */
    ptr.reset();
  
    /* Sprawdzenie czy wskazywany obiekt istnieje */
    if (ptr_2.lock())
        std::cout << "*ptr = " << *ptr << std::endl;
    else
        std::cout << "ptr = " << ptr << std::endl;
  
    return EXIT_SUCCESS;
}
