#include <iostream>

int main()
{
    /* Maksymalna wartość dla typu „unsigned int” */
    constexpr auto max = std::numeric_limits<unsigned>::max();
  
    char8_t at { u8'@' };
  
    /* Bezpieczna konwersja typu „char8_t”
       na typ „unsigned int” poprzez notację klamrową */
    unsigned mrAt { at };
  
    std::cout << "@ = " << mrAt << std::endl;
  
    /* Tutaj dzięki notacji klamrowej otrzymamy
       błąd przy próbie kompilacji, gdyż
       przypisujemy typ o większym zakresie
       do typu o mniejszym zakresie */
    //char8_t bad1 { unsigned { max } }; //błąd
  
    /* Niejawna konwersja z typu „unsigned int”
       na typ „char8_t” zniszczy oryginalną
       wartość zmiennej „max” */
    char8_t bad2 = max; //błąd (przycięcie wartości)
  
    /* Konwersja notacją z nawiasami (w stylu języka C)
       nie wypisze oryginalnej wartości zmiennej „max” */
    std::cout << "bad2 = " << (unsigned)bad2 << std::endl;
  
    return EXIT_SUCCESS;
}
