#include <iostream>
#include <memory>

using namespace std;

class Foo
{
public:
    string name;

    Foo(string n)
        : name{move(n)}
    { cout << "CTOR " << name << '\n'; }

    ~Foo() { cout << "DTOR " << name << '\n'; }
};

void f(shared_ptr<Foo> sp)
{
    cout << "f: wartość licznika odwołań wynosi " << sp.use_count() << '\n';
}

int main()
{
    shared_ptr<Foo> fa;

    {
        cout << "Początek zakresu wewnętrznego\n";

        shared_ptr<Foo> f1 {new Foo{"foo"}};
        auto            f2 (make_shared<Foo>("bar"));

        cout << "Wartość licznika odwołań obiektu f1 wynosi " << f1.use_count() << '\n';
        fa = f1;
        cout << "Wartość licznika odwołań obiektu f1 wynosi " << f1.use_count() << '\n';

    }
    cout << "Powrót do zakresu zewnętrznego\n";


    cout << fa.use_count() << '\n';

    cout << "Pierwsze wywołanie funkcji f()\n";
    f(fa);
    cout << "Drugie wywołanie funkcji f()\n";
    f(move(fa));
    cout << "Koniec funkcji main()\n";
}
