#include <iostream>
#include <iomanip>
#include <locale>

using namespace std;

void print_aligned_demo(int val, size_t width, char fill_char = ' ') {

    cout << "================\n";
    cout << setfill(fill_char);
    cout << left     << setw(width) << val << '\n';
    cout << right    << setw(width) << val << '\n';
    cout << internal << setw(width) << val << '\n';
}

int main()
{
    print_aligned_demo(123456, 15);
    print_aligned_demo(123456, 15, '_');

    cout << hex << showbase;
    print_aligned_demo(0x123abc, 15);

    cout << oct;
    print_aligned_demo(0123456, 15);

    cout << "Liczba szesnastkowa z dużymi literami: "
         << hex << uppercase << 0x123abc << '\n';

    cout << "Liczba: " << 100 << '\n';
    cout << dec;

    cout << "Ups, znów postać dziesiętna: " << 100 << '\n';

    cout << "Wartości true i false: "
         << true << ", " << false << '\n';
    cout << boolalpha
         << "Wartości true i false: "
         << true << ", " << false << '\n';

    cout << "Liczby typu double: "
         << 12.3 << ", "
         << 12.0 << ", "
         << showpoint << 12.0 << '\n';

    cout << "Liczba typu double w notacji naukowej: " << scientific << 123000000000.123 << '\n';
    cout << 100.0 << '\n';
    cout << "Liczba typu double w zwykłej postaci: " << fixed      << 123000000000.123 << '\n';

    cout << "Bardzo precyzyjna liczba typu double: " << setprecision(10) << 0.0000000001 << '\n';
    cout << "Mniej precyzyjna liczba typu double: " << setprecision(1) << 0.0000000001 << '\n';
}
