#include <iostream>
#include <iomanip>
#include <chrono>

using namespace std;

ostream& operator<<(ostream &os, const chrono::time_point<chrono::system_clock> &t)
{
    const auto tt   (chrono::system_clock::to_time_t(t));
    const auto loct (std::localtime(&tt));
    return os << put_time(loct, "%c");
}

using days = chrono::duration<
      chrono::hours::rep,
      ratio_multiply<chrono::hours::period, ratio<24>>>;

constexpr days operator ""_days(unsigned long long d)
{
    return days{d};
}

int main()
{
    auto now (chrono::system_clock::now());

    cout << "Bieżąca data i godzina: " << now << '\n';

    chrono::hours chrono_12h {12};

    cout << "Za 12 godzin będzie "
         << (now + chrono_12h)<< '\n';

    using namespace chrono_literals;
    cout << "12 godzin i 15 minut temu: "
         << (now - 12h - 15min) << '\n'
         << "Tydzień temu: "
         << (now - 7_days) << '\n';
}
