#include <iostream>
#include <queue>
#include <tuple>
#include <string>

int main()
{
    using item_type = std::pair<int, std::string>;
    std::initializer_list<item_type> il {
        {1, "zmyć naczynia"},
        {0, "obejrzeć telewizję"},
        {2, "odrobić pracę domową"},
        {0, "przeczytać komiks"},
    };

    std::priority_queue<item_type> q;

    for (const auto &p : il) {
        q.push(p);
    }

    while(!q.empty()) {
        std::cout << q.top().first << ": " << q.top().second << '\n';
        q.pop();
    }
    std::cout << '\n';
}
