/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
namespace std {
   template <class T>
   class allocator {
     public:
       // definicje typu
       typedef size_t    size_type;
       typedef ptrdiff_t difference_type;
       typedef T*        pointer;
       typedef const T*  const_pointer;
       typedef T&        reference;
       typedef const T&  const_reference;
       typedef T         value_type;

       // zwiaz alokator z typem U
       template <class U>
       struct rebind {
           typedef allocator<U> other;
       };

       // zwroca adres wartosci
       pointer address (reference value) const {
           return &value;
       }
       const_pointer address (const_reference value) const {
           return &value;
       }

       /* konstruktory oraz destruktor
        * - nie jest konieczne wykonanie zadnej czynnosci poniewaz nie ma zadnego stanu
        */
       allocator() throw() {
       }
       allocator(const allocator&) throw() {
       }
       template <class U>
         allocator (const allocator<U>&) throw() {
       }
       ~allocator() throw() {
       }

       // zwroc maksymalna liczbe elementow dla ktorej moze zostac przydzielona pamiec
       size_type max_size () const throw() {
           return numeric_limits<size_t>::max() / sizeof(T);
       }

       // przydziel pamiec dla num elementow typu T lecz jej nie inicjalizuj
       pointer allocate (size_type num,
                         allocator<void>::const_pointer hint = 0) {
           // przydziel pamiec za pomoca globalnego operatora new
           return (pointer)(::operator new(num*sizeof(T)));
       }

       // zainicjalizuj elementy umieszczone w przydzielonym obszarze pamieci p za pomoca wartosci value
       void construct (pointer p, const T& value) {
           // zainicjalizuj pamiec za pomoca operatora new
           new((void*)p)T(value);
       }

       // usun elementy w zainicjalizowanym obszarze pamieci p
       void destroy (pointer p) {
           // usun obiekty poprzez wywolanie ich destruktorow
           p->~T();
       }

       // zwolnij obszar pamieci p ktory zawieral usuniete elementy
       void deallocate (pointer p, size_type num) {
           // zwolnij obszar pamieci za pomoca wywolania globalnego operatora delete
           ::operator delete((void*)p);
       }
   };

   // zwroc wartosc okreslajaca wzajemna wymiennoesc specjalizacji tego alokatora
   template <class T1, class T2>
   bool operator== (const allocator<T1>&,
                    const allocator<T2>&) throw() {
       return true;
   }
   template <class T1, class T2>
   bool operator!= (const allocator<T1>&,
                    const allocator<T2>&) throw() {
       return false;
   }
}

