/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
namespace std {
   template <class T>
   class allocator {
     public:
       // definicje typow
       typedef size_t    size_type;
       typedef ptrdiff_t difference_type;
       typedef T*        pointer;
       typedef const T*  const_pointer;
       typedef T&        reference;
       typedef const T&  const_reference;
       typedef T         value_type;

       // alokator dowiazania do typu U
       template <class U>
       struct rebind {
           typedef allocator<U> other;
       };

       // zwroc adres wartosci
       pointer address (reference value) const {
           return &value;
       }
       const_pointer address (const_reference value) const {
           return &value;
       }

       /* konstruktory i destruktor
        * - nie ma nic do wykonania, poniewaz alokator nie posiada stanu
        */
       allocator() throw() {
       }
       allocator(const allocator&) throw() {
       }
       template <class U>
         allocator (const allocator<U>&) throw() {
       }
       ~allocator() throw() {
       }

       // zwroc maksymalna liczbe elementow, ktore moga zostac alokowane
       size_type max_size () const throw() {
           return numeric_limits<size_t>::max() / sizeof(T);
       }

       // alokuj, lecz nie inicjalizuj num elementow typu T
       pointer allocate (size_type num,
                         allocator<void>::const_pointer hint = 0) {
           // alokuj pamiec za pomoca globalnego operatora new
           return (pointer)(::operator new(num*sizeof(T)));
       }

       // inicjalizuj elementy alokowanego obszaru pamieci p wartoscia value
       void construct (pointer p, const T& value) {
           // inicjalizuj pamiec za pomoca operatora polozenia new
           new((void*)p)T(value);
       }

       // zniszcz elementy zainicjalizowanego obszaru pamieci p
       void destroy (pointer p) {
           // zniszcz obiekty przez wywolanie ich destruktora
           p->~T();
       }

       // zwolnij obszar pamieci p z usunietych elementow
       void deallocate (pointer p, size_type num) {
           // zwolnij pamiec za pomoca globalnego operatora new
           ::operator delete((void*)p);
       }
   };

   // poinformuj, ze wszystkie specjalizacje tego alokatora sa wzajemnie wymienne
   template <class T1, class T2>
   bool operator== (const allocator<T1>&,
                    const allocator<T2>&) throw() {
       return true;
   }
   template <class T1, class T2>
   bool operator!= (const allocator<T1>&,
                    const allocator<T2>&) throw() {
       return false;
   }
}

