/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "icstring.hpp"

int main()
{
    using std::cout;
    using std::endl;

    icstring s1("czesc");
    icstring s2("otto");
    icstring s3("cZESc");
    
    cout << std::boolalpha;
    cout << s1 << " == " << s2 << " : " << (s1==s2) << endl;
    cout << s1 << " == " << s3 << " : " << (s1==s3) << endl;

    icstring::size_type idx = s1.find("zes");
    if (idx != icstring::npos) {
        cout << "indeks ciagu \"zes\" w \"" << s1 << "\": "
             << idx << endl;
    }

    else {
        cout << "\"zes\" nie zostal odnaleziony w  \"" << s1 << endl;
    }
}
