/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <list>
#include <algorithm>
#include <iterator>

using namespace std;

int main()
{
    list<int> coll;

    // wstaw elementy od 6 do 1 oraz od 1 do 6
    for (int i=1; i<=6; ++i) {
        coll.push_front(i);
        coll.push_back(i);
    }

    // wypisz wszystkie elementy kolekcji
    copy (coll.begin(), coll.end(),
          ostream_iterator<int>(cout," "));
    cout << endl;

    // usun wszystkie elementy o wartosci 3
    // - zachowaj nowa pozycja konca
    list<int>::iterator end = remove (coll.begin(), coll.end(),
                                      3);

    // wypisz wynikowe elementy kolekcji
    copy (coll.begin(), end,
          ostream_iterator<int>(cout," "));
    cout << endl;

    // wypisz liczbe elementow wynikowych
    cout << "liczba usunietych elementow: "
         << distance(end,coll.end()) << endl;

    // usun 'usuniete' elementy
    coll.erase (end, coll.end());

    // wypisz wszystkie elementy zmodyfikowanej kolekcji
    copy (coll.begin(), coll.end(),
          ostream_iterator<int>(cout," "));
    cout << endl;
}
