/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <list>
#include <algorithm>
#include <iterator>

using namespace std;

int main()
{
    list<int> coll;

    // wstaw elementy od 6 do 1 oraz od 1 do 6
    for (int i=1; i<=6; ++i) {
        coll.push_front(i);
        coll.push_back(i);
    }

    // wypisz wszystkie elementy kolekcji
    cout << "przed:  ";
    copy (coll.begin(), coll.end(),           // zrodlo
          ostream_iterator<int>(cout," "));   // przeznaczenie
    cout << endl;

    // usun wszystkie elementy o wartosci 3
    remove (coll.begin(), coll.end(),         // zakres
            3);                               // wartosc

    // wypisz wszystkie elementy kolekcji
    cout << "po: ";
    copy (coll.begin(), coll.end(),           // zrodlo
          ostream_iterator<int>(cout," "));   // przeznaczenie
    cout << endl;
}
