/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <list>
#include <algorithm>
#include <cstdlib>      // dla funkcji abs()
using namespace std;

// predykat, ktory sprawdza czy podana liczba calkowita jest liczba pierwsza
bool isPrime (int number)
{
    // ignoruj znak ujemnosci
    number = abs(number);

    // liczby 0 i 1 nie sa liczbami pierwszymi
    if (number == 0 || number == 1) {
        return false;
    }
        
    // znajdz dzielnik, przez ktory liczba dzieli sie bez reszty
    int divisor;
    for (divisor = number/2; number%divisor != 0; --divisor) {
        ;
    }

    // jesli nie zostal znaleziony dzielnik wiekszy od 1, liczba jest liczba pierwsza
    return divisor == 1;
}

int main()
{
    list<int> coll;

    // wstaw elementy od 24 do 30
    for (int i=24; i<=30; ++i) {
        coll.push_back(i);
    }

    // szukaj liczby pierwszej
    list<int>::iterator pos;
    pos = find_if (coll.begin(), coll.end(),    // zakres
                   isPrime);                    // predykat
    if (pos != coll.end()) {
        // znaleziono
        cout << *pos << " to pierwsza znaleziona liczba pierwsza" << endl;
    }
    else {
        // nie znaleziono
        cout << "nie znaleziono zadnej liczby pierwszej" << endl;
    }
}
