/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <vector>
#include <string>
#include <algorithm>
#include <iterator>
using namespace std;

int main()
{
    vector<string> coll;

    /* z wejscia standardowego odczytaj wszystkie slowa
     * - zrodlo: wszystkie lancuchy do napotkania znaku konca pliku (EOF) lub do wystapienia bledu
     * - przeznaczenie: kolekcja coll (wstawianie)
     */
    copy (istream_iterator<string>(cin),    // poczatek zrodla
          istream_iterator<string>(),       // koniec zrodla
          back_inserter(coll));             // przeznaczenie

    // posortuj elementy
    sort (coll.begin(), coll.end());

    /* wypisz wszystkie elementy bez powtorzen
     * - zrodlo: kolekcja coll
     * - przeznaczenie: wyjscie standardowe (elementy rozdzielone znakami nowego wiersza)
     */
    unique_copy (coll.begin(), coll.end(),             // zrodlo
                 ostream_iterator<string>(cout,"\n")); // przeznaczenie
}
