/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <list>
#include <algorithm>
using namespace std;

int main()
{
    list<int> coll;
    list<int>::iterator pos;

    // wstaw elementy do 20 do 40
    for (int i=20; i<=40; ++i) {
        coll.push_back(i);
    }

    /* ustal pozycje elementu o wartosci 3
     * - nie ma takiego elementu, a wiec iterator pos otrzymuje wartosc funkcji coll.end()
     */
    pos = find (coll.begin(), coll.end(),    // zakres
                3);                          // wartosc
    
    /* odwroc kolejnosc elementow pomiedzy znalezionym elementem a koncem zakresu
     * - poniewaz iterator pos rowny jest wartosci funkcji coll.end(), odwracany jest pusty zakres
     */
    reverse (pos, coll.end());

    // ustal pozycje wartosci 25 oraz 35
    list<int>::iterator pos25, pos35;
    pos25 = find (coll.begin(), coll.end(),  // zakres
                  25);                       // wartosc
    pos35 = find (coll.begin(), coll.end(),  // zakres
                  35);                       // wartosc

    /* wypisz najwieksza wartosc z odpowiedniego zakresu
     * - uwaga: wlacznie z pos25, lecz bez pos35
     */
    cout << "max: " << *max_element (pos25, pos35) << endl;

    // przetwarzaj elementy wlacznie z ostatnia pozycja
    cout << "max: " << *max_element (pos25, ++pos35) << endl;
}
