/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <valarray>
using namespace std;

// wyswietl zawartosc tablicy valarray
template <class T>
void printValarray (const valarray<T>& va)
{
    for (int i=0; i<va.size(); i++) {
        cout << va[i] << ' ';
    }
    cout << endl;
}

int main()
{
    // utworz oraz zainicjalzuj tablice dziewiecioelementowa
    valarray<double> va(9);
    for (int i=0; i<va.size(); i++) {
        va[i] = i * 1.1;
    }

    // wyswietl zawartosc tablicy valarray
    printValarray(va);

    // pomnoz elementy w tablicy przez wartosc 2
    va *= 2.0;

    // ponownie wyswietl zawartosc tablicy valarray
    printValarray(va);

    // utworz druga tablice inicjalizowana wartosciami z tablicy pierwszej zwiekszonymi o dziesiec
    valarray<double> vb(va+10.0);

    // wyswietl zawartosc drugiej tablicy valarray
    printValarray(vb);

    // utworz trzecia tablice zawierajaca wynik operacji na obu istniejacych tablicach
    valarray<double> vc(9);
    vc = sqrt(va) + vb/2.0 - 1.0;
    
    // wyswietl zawartosc trzeciej tablicy valarray
    printValarray(vc);
}
