/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <valarray>
using namespace std;

// wyswietl elementy umieszczone w tablicy valarray w postaci tablicy dwuwymiarowej
template<class T>
void printValarray (const valarray<T>& va, int num)
{
    for (int i=0; i<va.size()/num; i++) {
        for (int j=0; j<num; j++) {
            cout << va[i*num+j] << ' ';
        }
        cout << endl;
    }
    cout << endl;
}

int main()
{
    // utworz tablice typu valarray dla 12 elementow
    valarray<double> va(12);

    // zainicjalizuj wartosci elementow tablicy valarray wartosciami 1.01, 2.02, ... 12.12
    for (int i=0; i<12; i++) {
        va[i] = (i+1) * 1.01;
    }
    printValarray(va,4);

    /* utworz tablice indeksow
     * - uwaga: element musi posiadac typ size_t
     */
    valarray<size_t> idx(4);
    idx[0] = 8;
    idx[1] = 0;
    idx[2] = 3;
    idx[3] = 7;

    // uzyj tablicy indeksow w celu wyswietlenia dziewiatego, pierwszego, czwartego oraz osmego elementu
    printValarray(valarray<double>(va[idx]), 4);

    // zmien pierwszy oraz czwarty element i wyswietl je ponownie
    va[0] = 11.11;
    va[3] = 44.44;
    printValarray(valarray<double>(va[idx]), 4);

    // a teraz wybierz elementy drugi, trzeci, szosty oraz dziewiaty
    // i przypisz im wartosc 99
    idx[0] = 1;
    idx[1] = 2;
    idx[2] = 5;
    idx[3] = 8;
    va[idx] = 99;

    // ponownie wyswietl cala zawartosc tabeli
    printValarray (va, 4);
}
