/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <valarray>
using namespace std;

// wyswietl wiersz po wierszu tablice typu valarray posiadajaca trzy wymiary
template<class T>
void printValarray3D (const valarray<T>& va, int dim1, int dim2)
{
    for (int i=0; i<va.size()/(dim1*dim2); ++i) {
        for (int j=0; j<dim2; ++j) {
            for (int k=0; k<dim1; ++k) {
                cout << va[i*dim1*dim2+j*dim1+k] << ' ';
            }
            cout << '\n';
        }
        cout << '\n';
    }
    cout << endl;
}

int main()
{
    /* tablica valarray o 24 elementach
     * - dwie grupy
     * - cztery wiersze
     * - trzy kolumny
     */
    valarray<double> va(24);

    // wypelnij tablice wartosciami
    for (int i=0; i<24; i++) {
        va[i] = i;
    }

    // wypisz elementy umieszczone w tablicy
    printValarray3D (va, 3, 4);

    // potrzebujemy dwuwymiarowe podzbiory trzy razy po trzy elementy
    // w 12 elementowych tablicach
    size_t lengthvalues[] = {  2, 3 };
    size_t stridevalues[] = { 12, 3 };
    valarray<size_t> length(lengthvalues,2);
    valarray<size_t> stride(stridevalues,2);

    // przypisz druga kolumne pierwszych trzech wierszy 
    // do pierwszej kolumny pierwszych trzech wierszy
    va[gslice(0,length,stride)]
        = valarray<double>(va[gslice(1,length,stride)]);

    // dodaj oraz przypisz trzeci z pierwszych trzech wierszy
    // do pierwszego z trzech pierwszych wierszy
    va[gslice(0,length,stride)]
        += valarray<double>(va[gslice(2,length,stride)]);
    
    // wyswietl elementy umieszczone w tablicy valarray
    printValarray3D (va, 3, 4);
}
