/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <list>
#include <algorithm>
using namespace std;

int main()
{
    list<int> coll;

    // wstaw elementy od 1 do 9
    for (int i=1; i<=9; ++i) {
        coll.push_back(i);
    }

    // ustal pozycje elementu o wartosci 5
    list<int>::iterator pos;
    pos = find (coll.begin(), coll.end(),    // zakres
                5);                          // wartosc

    // wypisz wartosc elementu
    cout << "pos:   " << *pos << endl;

    // konwertuj iterator na iterator odwrotny
    list<int>::reverse_iterator rpos(pos);

    // wypisz wartosc elementu, do ktorego odnosi sie iterator odwrotny
    cout << "rpos:  " << *rpos << endl;

    // konwertuj iterator odwrotny z powrotem na iterator normalny
    list<int>::iterator rrpos;
    rrpos = rpos.base();

    // wypisz wartosc elementu, do ktorego odnosi sie iterator normalny
    cout << "rrpos: " << *rrpos << endl;
}
