/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <deque>
#include <algorithm>
using namespace std;

void print (int elem)
{
    cout << elem << ' ';
}

int main()
{
    deque<int> coll;

    // wstaw elementy od 1 do 9
    for (int i=1; i<=9; ++i) {
        coll.push_back(i);
    }

    // ustal pozycje elementu o wartosci 2
    deque<int>::iterator pos1;
    pos1 = find (coll.begin(), coll.end(),    // zakres
                 2);                          // wartosc

    // ustal pozycje elementu o wartosci 7
    deque<int>::iterator pos2;
    pos2 = find (coll.begin(), coll.end(),    // zakres
                 7);                          // wartosc

    // wypisz wszystkie elementy z zakresu [pos1,pos2)
    for_each (pos1, pos2,     // zakres
              print);         // operacja
    cout << endl;

    // konwertuj iteratory na iteratory odwrotne
    deque<int>::reverse_iterator rpos1(pos1);
    deque<int>::reverse_iterator rpos2(pos2);

    // wypisz wszystkie elementy z zakresu [pos1,pos2) w odwrotnej kolejnosci
    for_each (rpos2, rpos1,   // zakres
              print);         // operacja
    cout << endl;
}
