/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <vector>
#include <algorithm>
#include <iterator>
using namespace std;

int main()
{
    // utworz iterator strumieniowy wyjsciowy dla strumienia cout
    // - wartosci rozdzielane sa znakiem nowego wiersza
    ostream_iterator<int> intWriter(cout,"\n");

    // zapisz elementy z wykorzystaniem typowego interfejsu iteratora
    *intWriter = 42;
    intWriter++;
    *intWriter = 77;
    intWriter++;
    *intWriter = -5;

    // utworz kolekcje zawierajaca elementy od 1 do 9
    vector<int> coll;
    for (int i=1; i<=9; ++i) {
        coll.push_back(i);
    }

    // zapisz wszystkie elementy bez separatora
    copy (coll.begin(), coll.end(),
          ostream_iterator<int>(cout));
    cout << endl;

    // zapisz wszystkie elementy z separatorem " < "
    copy (coll.begin(), coll.end(),
          ostream_iterator<int>(cout," < "));
    cout << endl;
}
